/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

#define SPEED		 0.5
#define BALLS   	 5
#define SQRADIUS     10.0
#define BOUNCES 	 2
#define EYE_DIST     0.9
#define Z_FAR		 1000.0
#define SELF_COLOUR	 0.5
#define MELT_AMOUNT	 0.5
#define SUN_DIFFUSE	 0.4
#define SUN_SPECULAR 0.2
#define SUN_SHININESS 20.0
#define FLOOR_AMOUNT 0.7

const vec3 Bgnd = vec3 (0.05, 0.20, 0.33);
const vec3 Sun = vec3 (1.0, 2.0, -2.0)/3.0;  // normalized!
const vec3 Floor = vec3 (0.0, -1.0, 0.0);  // ditto

struct Ball
{
    vec3 M;
    vec3 C;
} B[BALLS];

void setup (float t)
{
    for (int i = 0; i < BALLS; i++)
    {
        float fi = float (i);
        B[i].M.x = 10.0 * sin (0.91*fi + t);
        B[i].M.y =  5.0 * cos (1.42*fi + t);
        B[i].M.z = 12.5 + 7.5*sin (2.73*fi + t);

        int mi = int (mod (float (i), float (3)));  // %?
        if (     mi == 0) B[i].C = vec3 (0.8, 0.0, 0.0);
        else if (mi == 1) B[i].C = vec3 (0.0, 0.5, 0.0);
        else              B[i].C = vec3 (0.0, 0.0, 0.9);
    }
}

bool ray (vec3 P, vec3 D, out vec3 Q, out vec3 N, out vec3 C)
{
    float a = dot (D, D);
    float p = dot (P, P);
    vec3 hitM;
    
    Q.z = Z_FAR;

    for (int i = 0; i < BALLS; i++)
    {
        vec3 M = B[i].M;  // faster? slower?
        float b = 2.0 * dot (D, (P - M));
        float c = dot (M, M) - 2.0*dot (M, P) + p - SQRADIUS;
        float s = b*b - 4.0*a*c;

        if (s >= 0.0)
        {
            s = sqrt (s);
            
	        float t1 = (-b + s) / (2.0*a);
	        float t2 = (-b - s) / (2.0*a);
            
            float z1 = P.z + t1*D.z;
            float z2 = P.z + t2*D.z;
            
            if (z1 < Q.z || z2 < Q.z)
            {
                if (z1 < z2)
                {
                    Q.x = P.x + t1*D.x;
                    Q.y = P.y + t1*D.y;
                    Q.z = z1;
                }
                else
                {
                    Q.x = P.x + t2*D.x;
                    Q.y = P.y + t2*D.y;
                    Q.z = z2;
                }
                C = B[i].C;
                hitM = M;
            }
        }
    }
    
    if (Q.z < Z_FAR)
    {
        N = Q - hitM;
        N.x += MELT_AMOUNT*sin (Q.x);
        N.y += MELT_AMOUNT*sin (Q.y);
        N.z += MELT_AMOUNT*sin (Q.z);
        N = normalize (N);
        return true;
    }
    
    return false;
}

void main()
{
    vec3 P = vec3 (
        2.0*(gl_FragCoord.x / iResolution.x - 0.5),
        2.0*(gl_FragCoord.y / iResolution.y - 0.5)*(iResolution.y / iResolution.x),
        0.0);

    vec3 D = vec3 (P.xy, EYE_DIST);
    vec3 Q, N;

    vec3 colour;
    vec3 mixed = vec3 (0.0, 0.0, 0.0);
    float mx = 1.0;

    setup (iGlobalTime*SPEED);

    for (int i = 0; i <= BOUNCES; i++)
    {
        if (ray (P, D, Q, N, colour))
        {
            float d = dot (N, Sun);
            
            if (d > 0.0) 
            { 
                colour += SUN_DIFFUSE * d;
                colour += SUN_SPECULAR * pow (d, SUN_SHININESS);
            }
            
            d = FLOOR_AMOUNT * dot (N, Floor);
            if (d > 0.0) colour.g = max (colour.g, d);
            
            mixed = mix (mixed, colour, mx);
            mx *= SELF_COLOUR;
            P = Q;
            D = N;
        } else break;
    }
    
    gl_FragColor = vec4 (mix (mixed, Bgnd, mx), 1.0);
}
